#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//colored wave effectMod01.fsh     by   rockhard  
//https://www.shadertoy.com/view/X3SXzV
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

   float rand(vec3 p) {
    return fract(sin(dot(p, vec3(12.345, 67.89, 412.12))) * 42123.45) * 2.0 - 1.0;
}
// A perlin noise function. Since we are not using textures, we am gonna sample 8 corners of a cube.
float noise(vec3 p) {
    vec3 u = floor(p);
    vec3 v = fract(p);
    vec3 s = smoothstep(0.0, 1.0, v);
    
    float a = rand(u);
    float b = rand(u + vec3(1.0, 0.0, 0.0));
    float c = rand(u + vec3(0.0, 1.0, 0.0));
    float d = rand(u + vec3(1.0, 1.0, 0.0));
    float e = rand(u + vec3(0.0, 0.0, 1.0));
    float f = rand(u + vec3(1.0, 0.0, 1.0));
    float g = rand(u + vec3(0.0, 1.0, 1.0));
    float h = rand(u + vec3(1.0, 1.0, 1.0));
    
    return mix(mix(mix(a, b, s.x), mix(c, d, s.x), s.y),
               mix(mix(e, f, s.x), mix(g, h, s.x), s.y),
               s.z);
}
float fbm(vec3 p) {   
    vec3 q = p+vec3(0.0, 0.4, 0.26) * iTime;
    float f = 0.5 * noise(q); 
    return clamp(f - p.y, 0.0, 1.0);
}
float map(vec3 p){ return fbm(p)+p.x; }

vec3 normal(vec3 p){float t=map(p);
    return normalize(vec3(t-map(vec3(p.x-0.0002,p.y,p.z)),
    t-map(vec3(p.x,p.y-0.0002,p.z)),t-map(vec3(p.x,p.y,p.z-0.0002))));
}
#define MAXD 40.0
float trace(inout vec3 p,vec3 ro, vec3 rd){  
   float dd=0.0;      
       for(float i = 0.0; i<16.0; i++){
            p =ro+ rd*dd;
            float d = map(p);dd+=d*0.6;
            if(abs(d)<0.004) break;
            if(dd>MAXD ){ dd = MAXD ; break; }
        }
        return dd;
}
float getWave(vec3 uv,vec3 camPos){
    vec2 a = vec2(0.0,-1.2);
    vec2 d = vec2(-1.0,1.0);
    camPos.yz = camPos.yz*cos(a.x) + camPos.zy*d.xy*sin(a.x);
    camPos.zx = camPos.zx*cos(a.y) + camPos.xz*d.xy*sin(a.y);
        
    vec3 camK = -normalize(camPos);
    vec3 camI = normalize(cross(vec3(0.0,1.0,0.0),camK));
    vec3 camJ = cross(camK,camI);    
    vec3 ray = uv.x*camI + uv.y*camJ + uv.z*camK;
    ray = normalize( ray );
    vec3 p = vec3(0.0);
    vec3 ro=camPos;
    vec3 rd=ray;
    float t = trace(p,ro,rd);  
    vec3 n =normal(p);  
    return 1.0- n.x;
}
//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
   vec2 UV=gl_FragCoord.xy/iResolution.xy;
 vec3 uv = vec3((gl_FragCoord.xy-iResolution.xy*.5)/iResolution.x, 1.0);     
     vec3  camPos = vec3( 0.0, 1.0, -2.6);    
     float v=getWave(uv,camPos)*0.2;
     camPos = vec3( 1.6, 1.0, -1.0);    
     v+=getWave(uv,camPos)*0.6;    
   vec3 col=vec3(UV.x*UV.x*4.4,2.6*UV.y,4.2*(1.0-UV.x))*v;

    // Output to screen
    fragColor = vec4(col,1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
//gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

